from ...libs.functions.common_ui_elements import collapsable
from .common_functions import condition_enabled
from ...addon.naming import FluidLabNaming


def physics_adv_ui(toggles, col, active_emitter_item, physics_props, anim_physics_props, anim_weights_props):

    if not active_emitter_item:
        return

    switchers_props = active_emitter_item.switchers

    # global_mode_integration_sect
    integration_local_mode = {
            "type": "bool",
            "from": switchers_props,
            "prop": "global_mode_integration_sect",
            "text": "",
            "toggle": True,
            "icon": 'LINKED' if switchers_props.global_mode_integration_sect else 'UNLINKED',
            "emboss": False,
    }
    integration = collapsable(
        col,
        toggles,
        "fs_integration",
        "Integration",
        'MOD_TIME',
        align=True,
        button_settings1=integration_local_mode
    )
    if integration:
        grid = integration.grid_flow(row_major=True, even_columns=True, even_rows=True, align=True, columns=2)
        
        timestep = grid.row(align=True)
        timestep.enabled = condition_enabled(anim_physics_props, "timestep")
        timestep.prop(physics_props, "timestep", text="Timestep")

        grid.prop(physics_props, "use_adaptive_subframes", text="Adaptive")

        subframes = grid.row(align=True)
        subframes.enabled = condition_enabled(anim_physics_props, "subframes")
        subframes.prop(physics_props, "subframes", text="Subframes")
        
        threshold_target = grid.row(align=True)
        threshold_target.enabled = physics_props.use_adaptive_subframes
        threshold_target.prop(physics_props, "courant_target", text="Threshold")
    
    # global_mode_physics_sect
    physics_local_mode = {
            "type": "bool",
            "from": switchers_props,
            "prop": "global_mode_physics_sect",
            "text": "",
            "toggle": True,
            "icon": 'LINKED' if switchers_props.global_mode_physics_sect else 'UNLINKED',
            "emboss": False,
    }
    physics = collapsable(
        col,
        toggles,
        "fs_physics",
        "Physics",
        'PHYSICS',
        align=True,
        button_settings1=physics_local_mode
    )
    if physics:

        physics.prop(physics_props, "mass", text="Mass")
        physics.prop(physics_props, "use_multiply_size_mass", text="Multiply mass with size")

        stiffness = physics.row(align=True)
        stiffness.enabled = condition_enabled(anim_physics_props, "stiffness")
        stiffness.prop(physics_props, "stiffness", text="Stiffness")

        viscosity = physics.row(align=True)
        viscosity.enabled = condition_enabled(anim_physics_props, "linear_viscosity")
        viscosity.prop(physics_props, "linear_viscosity", text="Viscosity")

        drag_and_damping = physics.row(align=True)        
        drag_and_damping.prop(physics_props, "drag_factor", text="Drag | Damping")
        drag_and_damping.prop(physics_props, "damping", text="")

        physics.prop(physics_props, "use_size_deflect", text="Size Deflect")

        # collisions collection:
        physics.prop(physics_props, "collision_coll", text="Collisions")

    # global_mode_advanced_b_sect
    advanced_b_local_mode = {
        "type": "bool",
        "from": switchers_props,
        "prop": "global_mode_advanced_b_sect",
        "text": "",
        "toggle": True,
        "icon": 'LINKED' if switchers_props.global_mode_advanced_b_sect else 'UNLINKED',
        "emboss": False,
    }
    advanced_behavior = collapsable(
        col,
        toggles,
        "fs_physics_advanced_behavior",
        "Advanced Behavior",
        'ONIONSKIN_ON',
        align=True,
        button_settings1=advanced_b_local_mode
    )
    if advanced_behavior:
        
        advanced_behavior.prop(physics_props, "repulsion", slider=True, text="Repulsion Factor")
        advanced_behavior.prop(physics_props, "stiff_viscosity", slider=True, text="Stiff Viscosity")

        fluid_radius = advanced_behavior.row(align=True)
        fluid_radius.prop(physics_props, "fluid_radius", text="Interaction Radius", slider=True)
        fluid_radius.enabled = not active_emitter_item.emission.fluid_radius_animed and condition_enabled(anim_physics_props, "fluid_radius")

        advanced_behavior.prop(physics_props, "rest_density", slider=True, text="Rest Density")

    
    # global_mode_advanced_field_weights_sect
    field_weights_local_mode = {
            "type": "bool",
            "from": switchers_props,
            "prop": "global_mode_advanced_field_weights_sect",
            "text": "",
            "toggle": True,
            "icon": 'LINKED' if switchers_props.global_mode_advanced_field_weights_sect else 'UNLINKED',
            "emboss": False,
    }
    field_weights = collapsable(
        col,
        toggles,
        "field_weights",
        "Field Weights",
        'OUTLINER_OB_FORCE_FIELD',
        align=True,
        button_settings1=field_weights_local_mode
    )
    if field_weights:
        field_weights.prop(physics_props, "collection", text="Effector Collection")
        for prop in FluidLabNaming.weights:
            row = field_weights.row(align=True)
            row.enabled = condition_enabled(anim_weights_props, prop)
            row.prop(physics_props, prop, slider=True)
            
        
